<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('phone', 'email', 'password', 'd_o_b', 'blood_type_id', 'last_donation_date', 'city_id', 'pin_code');

    public function blood_type()
    {
        return $this->belongsTo('App\Models\Blood_Type');
    }

    public function city_id()
    {
        return $this->belongsTo('App\Models\City');
    }

    public function Donation_Request()
    {
        return $this->hasMany('App\Models\Donation_Request');
    }

    public function notifications()
    {
        return $this->belongsToMany('App\Models\Notification');
    }

}